/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 1.22)
 *
 *  Wersja "konwencjonalna", zawierajca rzutowanie wskanikw funkcyjnych
 *  (zmienna stanowa jest wskanikiem na wskanik na funkcj).
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdio.h>

#ifdef __STDC__
void statemachine(void);
#endif
void statemachine();

main()
{
statemachine();
return 0;
}

typedef int (*funcptr)();	  /* oglny wskanik do funkcji */
typedef funcptr (*ptrfuncptr)();  /* wskanik do funkcji, ktra zwraca funcptr */

funcptr start(), stop();
funcptr state1(), state2(), state3();

void statemachine()
{
	ptrfuncptr state = start;

	while(state != stop)
#ifdef oldway
		state = (ptrfuncptr)(*state)();
#else
		state = (ptrfuncptr)state();
#endif
}

static int count;


funcptr start()
{
	count = 0;
	return (funcptr)state1;
}

funcptr state1()
{
	printf("Stan nr 1\n");
	return (funcptr)state2;
}

funcptr state2()
{
	printf("Stan nr 2\n");
	return (funcptr)state3;
}

funcptr state3()
{
	count++;
	printf("Stan nr 3\n");
	return (count < 3) ? (funcptr)state1 : (funcptr)stop;
}

funcptr stop()
{
	printf("Koniec\n");
	exit(1);
}
